// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_VI_H
#define HW_VI_H

#include "hw_internal.h"

#define VIDEO_INTERRUPTS(macro) macro(0) macro(1) macro(2) macro(3)

class HwVI {
public:
	template<WORD number> static void ww_di(Hardware *h, WORD offset, DWORD data);
	template<WORD number> static void wh_di_high(Hardware *h, WORD offset, WORD data);
	template<WORD number> static void wh_di_low(Hardware *h, WORD offset, WORD data);

	static WORD rh_vct(Hardware *h, WORD offset);
	static WORD rh_hct(Hardware *h, WORD offset);
	static void ww_xfb(Hardware *h, WORD offset, DWORD data);
	static void wh_vtr(Hardware *h, WORD offset, WORD data);
	static void wh_dcr(Hardware *h, WORD offset, WORD data);
	static void ww_cr(Hardware *h, WORD offset, DWORD data);
	static void wh_xfb_high(Hardware *h, WORD offset, WORD data);
	static void wh_xfb_low(Hardware *h, WORD offset, WORD data);

	template<WORD number> static void visimple_event(Hardware *h);
	static void visi_timeout_event(Hardware *h);
	static void VISleep(Hardware *h);
private:
	static void doACV(Hardware *h, WORD data);
	static void doDCR(Hardware *h, WORD data);
	static bool doVCT(Hardware *h);
	template<WORD number> static void set_viint(Hardware *h);
	template<WORD number> static void vi_event(Hardware *h);
	static void doXFB(Hardware *h, int slot, DWORD data);
	static void raiseVI(Hardware *h, DWORD di, WORD number);
};

#define VI_DIINT 0x80000000
#define VI_DIENB 0x10000000
#define VI_DI(number) (0x2030 + (number)*4)

#define LINES_PER_FRAME WORD(h->vi.mode == 1 ? 625 : 525) //this may not be correct
#define FRAMES_PER_SECOND_MODED(mode) ((mode) == 1 ? 50 : 60) //25 : 30)
#define FRAMES_PER_SECOND FRAMES_PER_SECOND_MODED(h->vi.mode)
#define LINES_PER_SECOND (FRAMES_PER_SECOND * LINES_PER_FRAME)
#define PIXELS_PER_SECOND (LINES_PER_SECOND * 640)
#define ET_PER_FRAME ((g::timing_mode == g::TM_REALTIME ? g::rtcf : BOGOMIPS) / \
	FRAMES_PER_SECOND)

#endif	//HW_VI_H
